package java.game.cars;

import java.game.*;
import java.util.*;
import java.game.parts.*;
import java.game.parts.enginepart.airfueldeliverysystem.*;

public class Zed_chassis extends Zed_models
{
	public Zed_chassis( int id )
	{
		super( id );
		carCategory = PACKAGE;
		
		vehicleName = vendorName = "Zed";
		name = getName();
		
		rID_blueprint = cars.cat_02.Zed:0x018Ar;
		defColorIndex = GameLogic.CARCOLOR_BLACK;
		
		game_version = 2.31;
		ban_mufflers = own_suspension = allow_missing_seats = 1;

		value = 5399;
 
		fully_stripped_drag = 0.45;
		min_drag = 0.291;
		drag_reduction_mul = 0.55;
		
		parts_shop_sml = new int[2];
		parts_shop_sml[0] = cars.cat_02.Zed:0x01D5r; //Left taillight dark
		parts_shop_sml[1] = cars.cat_02.Zed:0x01C1r; //Right taillight dark
		
		parts_shop_big = new int[1];
		parts_shop_big[0] = cars.cat_02.Zed:0x00D4r; //Left exhaust
	}

	public void addStockParts( Descriptor desc )
	{
		int actcolor = desc.color;
		float optical = desc.optical;
		float power = desc.power;
		
		super.addStockParts( actcolor, optical, power );

		float part_random;

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_02.zed:0x000000B4r, "F windshield", actcolor, optical, power );
			addPart( cars.cat_02.zed:0x000000B5r, "FL door", actcolor, optical, power );
			addPart( cars.cat_02.zed:0x000000B8r, "L headlights", actcolor, optical, power );
			addPart( cars.cat_02.zed:0x000000BBr, "R windshield", actcolor, optical, power );
			addPart( cars.cat_02.zed:0x000000BDr, "R headlights", actcolor, optical, power );
			addPart( cars.cat_02.zed:0x000000BEr, "FR door", actcolor, optical, power );
			addPart( cars.cat_02.zed:0x000000C1r, "R taillights", actcolor, optical, power );
			addPart( cars.cat_02.zed:0x000000CEr, "FR seat", actcolor, optical, power );
			addPart( cars.cat_02.zed:0x000000CFr, "FL seat", actcolor, optical, power );
			addPart( cars.cat_02.zed:0x000000D4r, "L muffler", actcolor, optical, power );
			addPart( cars.cat_02.zed:0x000000D5r, "L taillights", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_02.zed:0x000000B4r, "F windshield", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.zed:0x000000B5r, "FL door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.zed:0x000000B8r, "L headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.zed:0x000000BBr, "R windshield", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.zed:0x000000BDr, "R headlights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.zed:0x000000BEr, "FR door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.zed:0x000000C1r, "R taillights", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.zed:0x000000CEr, "FR seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.zed:0x000000CFr, "FL seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.zed:0x000000D4r, "L muffler", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.zed:0x000000D5r, "L taillights", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_02.zed:0x000000B3r, "F bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.zed:0x000000B9r, "L sideskirt", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.zed:0x000000BAr, "R bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.zed:0x000000BCr, "trunk", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_02.zed:0x000000C0r, "R sideskirt", actcolor, optical, power );
		} else
		{
			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_02.zed:0x000000C3r, "L sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_02.zed:0x000000C2r, "L sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_02.zed:0x000000B9r, "L sideskirt", actcolor, optical, power );

			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_02.zed:0x000000CBr, "R sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_02.zed:0x000000CAr, "R sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_02.zed:0x000000C0r, "R sideskirt", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.5 ) addPart( cars.cat_02.zed:0x000000C4r, "trunk 2", actcolor, optical, power ); else
			addPart( cars.cat_02.zed:0x000000BCr, "trunk", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_02.zed:0x000000C6r, "F bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_02.zed:0x000000C5r, "F bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_02.zed:0x000000B3r, "F bumper", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_02.zed:0x000000C8r, "R bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_02.zed:0x000000C7r, "R bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_02.zed:0x000000BAr, "R bumper", actcolor, optical, power );
		}

		addPart( cars.cat_02.zed:0x000000D0r, "FL suspension" );
		addPart( cars.cat_02.zed:0x000000D1r, "FR suspension" );
		addPart( cars.cat_02.zed:0x000000D2r, "RL suspension" );
		addPart( cars.cat_02.zed:0x000000D3r, "RR suspension" );

		if ( optical < 1.0 )
		{
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );
			addPart( parts.wheels_combo:0x000000C1r, "wheel" );

		} else
		{
			if ( random() > 0.5 ) // Speed 6 //
			{
				if ( (power+optical)*0.5 >= 1.75 ) // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
					addPart( parts.wheels_combo:0x000000BAr, "wheel" );
					addPart( parts.wheels_combo:0x000000BAr, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 ) // 255-19F 255-19R //
				{
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
					addPart( parts.wheels_combo:0x000000B9r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 ) // 215-17F 255-17R //
				{
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000987r, "wheel" );
					addPart( parts.wheels_combo:0x00000987r, "wheel" );
				} else                             // 215-17F 215-17R //
				{
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
					addPart( parts.wheels_combo:0x00000986r, "wheel" );
				}
			} else
			if ( random() > 0.5 ) // Star //
			{
				if ( (power+optical)*0.5 >= 1.75 ) // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
					addPart( parts.wheels_combo:0x000000BEr, "wheel" );
					addPart( parts.wheels_combo:0x000000BEr, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 ) // 255-19F 255-19R //
				{
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
					addPart( parts.wheels_combo:0x000000BDr, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 ) // 215-17F 255-17R //
				{
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000098Br, "wheel" );
					addPart( parts.wheels_combo:0x0000098Br, "wheel" );
				} else                             // 215-17F 215-17R //
				{
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
					addPart( parts.wheels_combo:0x0000098Ar, "wheel" );
				}
			} else                // Rotor //
			{
				if ( (power+optical)*0.5 >= 1.75 ) // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
					addPart( parts.wheels_combo:0x000000B1r, "wheel" );
					addPart( parts.wheels_combo:0x000000B1r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.5 ) // 255-19F 255-19R //
				{
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
					addPart( parts.wheels_combo:0x000000B0r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.25 ) // 215-17F 255-17R //
				{
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
					addPart( parts.wheels_combo:0x00000969r, "wheel" );
					addPart( parts.wheels_combo:0x00000969r, "wheel" );
				} else                             // 215-17F 215-17R //
				{
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
					addPart( parts.wheels_combo:0x00000968r, "wheel" );
				}
			}
		}

		if ( power >= 1.666 ) // Bilstein street racer //
		{
			addPart( parts.running_gear:0x000001F6r, "shock" );
			addPart( parts.running_gear:0x000001F6r, "shock" );
			addPart( parts.running_gear:0x000001F7r, "shock" );
			addPart( parts.running_gear:0x000001F7r, "shock" );
		} else
		if ( power >= 1.333 ) // Bilstein aftermarket //
		{
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
		} else                // stock //
		{
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
		}

		if ( power >= 1.666 ) // H&R aftermarket 37000 Nm 10" //
		{
			addPart( parts.running_gear:0x00000207r, "spring" );
			addPart( parts.running_gear:0x00000207r, "spring" );
			addPart( parts.running_gear:0x00000208r, "spring" );
			addPart( parts.running_gear:0x00000208r, "spring" );
		} else
		if ( power >= 1.333 ) // stock 28000Nm 12" //
		{
			addPart( parts.running_gear:0x0000020Br, "spring" );
			addPart( parts.running_gear:0x0000020Br, "spring" );
			addPart( parts.running_gear:0x0000020Cr, "spring" );
			addPart( parts.running_gear:0x0000020Cr, "spring" );
		} else                // stock 23000Nm 12" //
		{
			addPart( parts.running_gear:0x00000215r, "spring" );
			addPart( parts.running_gear:0x00000215r, "spring" );
			addPart( parts.running_gear:0x00000216r, "spring" );
			addPart( parts.running_gear:0x00000216r, "spring" );
		}

		if ( power >= 1.666 ) // Baer drilled 12.5"F 12.5"R //
		{
			addPart( parts.running_gear:0x00000108r, "FL brake" );
			addPart( parts.running_gear:0x00000132r, "FR brake" );
			addPart( parts.running_gear:0x00000136r, "RL brake" );
			addPart( parts.running_gear:0x00000146r, "RR brake" );
		} else
		if ( power >= 1.333 ) // stock varied size 12.0"F 11.5"R //
		{
			addPart( parts.running_gear:0x000021FFr, "FL brake" );
			addPart( parts.running_gear:0x000022FFr, "FR brake" );
			addPart( parts.running_gear:0x000023FFr, "RL brake" );
			addPart( parts.running_gear:0x000024FFr, "RR brake" );
		} else                // stock universal 11.0"F 11.0"R //
		{
			addPart( parts.running_gear:0x000025FFr, "UL brake" );
			addPart( parts.running_gear:0x000026FFr, "UR brake" );
			addPart( parts.running_gear:0x000025FFr, "UL brake" );
			addPart( parts.running_gear:0x000026FFr, "UR brake" );
		}

		if ( power >= 1.8 ) // supersport //
		{
			addPart( parts.running_gear:0x00000164r, "F swaybar" );
			addPart( parts.running_gear:0x00000181r, "R swaybar" );
		} else
		if ( power >= 1.3 ) // sport //
		{
			addPart( parts.running_gear:0x00000154r, "F swaybar" );
			addPart( parts.running_gear:0x0000015Cr, "R swaybar" );
		} else              // stock //
		{
			addPart( parts.running_gear:0x000041FFr, "F swaybar" );
			addPart( parts.running_gear:0x000042FFr, "R swaybar" );
		}

		if ( power >= 1 ) addPart( parts.engines.I4:0x0000000Br, "2.5L I4 engine", actcolor, optical, (power-1)/1*2 ); else
		if ( power >= 0.833 ) addPart( parts.engines.I4:0x0000000Ar, "2.2L I4 engine", actcolor, optical, (1-power)/0.166*2 ); else
		if ( power >= 0.666 ) addPart( parts.engines.I4:0x00000009r, "2.0L I4 engine", actcolor, optical, (0.833-power)/0.166*2 ); else
		if ( power >= 0.5 ) addPart( parts.engines.I4:0x00000008r, "1.8L I4 engine", actcolor, optical, (0.666-power)/0.166*2 );

		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_02.zed:0x000000B7r, "hood", actcolor, optical, power );
		} else
		{
			part_random = random();
			if ( optical-1 >= 0.5 ) addPart( cars.cat_02.zed:0x000000C9r, "hood 2", actcolor, optical, power ); else
			addPart( cars.cat_02.zed:0x000000B7r, "hood", actcolor, optical, power );
		}

		if ( power >= 1.666 ) addPart( parts:0x000000E9r, "silver battery" ); else
		if ( power >= 1.333 ) addPart( parts:0x000000E8r, "blue battery" ); else
		addPart( parts:0x000053FFr, "black battery" );
		
		addPart( cars.cat_02.Zed:0x0000FFB4r, "steering wheel" );
	}
	
	public void setDrive(int fwd, int rwd, float drive_front)
	{
		if((fwd && !rwd) || (rwd && !fwd)) super.setDrive(0,1,0.0); //2WD all becomes RWD
		else super.setDrive(fwd, rwd, drive_front); //Leave AWD alone 
	}
}
